#include "usbadc10.h"
#include <algorithm>
#include <stdexcept>
#define PICOJSON_USE_INT64
#define PICOJSON_USE_UINT64
#include <picojson.h>
result_t usbadc10_get_profile(device_t handle, char **buffer, void *(*allocate)(size_t))
{
    result_t result = result_ok;
    picojson::value::object profile_json;
    {
        usbadc10_calibration_settings_t command_output;
        picojson::value::object command_output_json;
        if(usbadc10_get_calibration_settings(handle, &command_output) != result_ok) result = result_error;
        {
            picojson::array field_output_json(4);
            for(unsigned int i = 0; i < 4; i++)
                field_output_json[i] = picojson::value(static_cast<uint64_t>(command_output.Reserved[i]));
            command_output_json["Reserved"] = picojson::value(field_output_json);
        }
        profile_json["calibration_settings"] = picojson::value(command_output_json);
    }

    std::string out_str = picojson::value(profile_json).serialize(true);
    size_t size = out_str.size();
    (*buffer) = static_cast<char *>(allocate(size + 1));
    memcpy((*buffer), out_str.c_str(), size);
    (*buffer)[size] = '\0';
    return result;
}
result_t usbadc10_set_profile(device_t handle, char *buffer)
{
    result_t result = result_ok;
    picojson::value profile_json;
    try
    {
        picojson::parse(profile_json, buffer);
    }
    catch(const std::exception &)
    {
        return result_error;
    }
    if(!profile_json.is<picojson::object>())
    {
        return result_error;
    }
    if(profile_json.contains("calibration_settings") && profile_json.get("calibration_settings").is<picojson::object>())
    {
        usbadc10_calibration_settings_t command_output;
        if(usbadc10_get_calibration_settings(handle, &command_output) != result_ok) result = result_error;
        picojson::value &command_output_json = profile_json.get("calibration_settings");
        if(command_output_json.contains("Reserved") && command_output_json.get("Reserved").is<picojson::array>()) 
        {
            picojson::array &field_output_json = command_output_json.get("Reserved").get<picojson::array>();
            if(field_output_json.size() == 4 && std::all_of(field_output_json.cbegin(), field_output_json.cend(), [](picojson::value const &e) { return e.is<uint64_t>(); })) 
            {
                unsigned int i;
                for(i=0; i < 4; i++) {
                    command_output.Reserved[i] = static_cast<uint8_t>(field_output_json[i].get<uint64_t>());
                }
            }
            else
            {
                result = result_error;
            }
        }
        else
        {
            result = result_error;
        }
        if(usbadc10_set_calibration_settings(handle, &command_output) != result_ok) result = result_error;
    }

    return result;
}
