#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QGroupBox>
#include <QListWidget>

#include <limits>
#include <stdint.h>

#include "iopanel.h"

#include "intarroutput.h"
#include "intarrinput.h"

#include "intinput.h"
#include "intoutput.h"

#include "floatinput.h"
#include "floatoutput.h"

#include "floatarrinput.h"
#include "floatarroutput.h"

#include "container.h"

#include "iopanel.h"

#include "usbadc10.h"

namespace Ui {
class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

    QListWidget *log;

    Container *MainContainer;

    void AddIOPanel(iopanel* Panel);

    void logAdd(QString str);
    void logClear();

    QLineEdit *comedit;

    device_t device;

    /* iopanels for commands
     * THIS CODE IS AUTOGENERATED
     */

    

    


    // command get_identity_information
    iopanel* get_identity_informationiop;

    // req arguments
    // resp arguments
    // argument Manufacturer type ('uint8_t', '[16]')
    
    IntArrOutput* get_identity_informationManufactureroutputwidget;
    
    // argument ProductName type ('uint8_t', '[16]')
    
    IntArrOutput* get_identity_informationProductNameoutputwidget;
    
    // argument ControllerName type ('uint8_t', '[16]')
    
    IntArrOutput* get_identity_informationControllerNameoutputwidget;
    
    // argument HardwareMajor type ('uint8_t', '')
    
    IntOutput* get_identity_informationHardwareMajoroutputwidget;
    
    // argument HardwareMinor type ('uint8_t', '')
    
    IntOutput* get_identity_informationHardwareMinoroutputwidget;
    
    // argument HardwareBugfix type ('uint16_t', '')
    
    IntOutput* get_identity_informationHardwareBugfixoutputwidget;
    
    // argument BootloaderMajor type ('uint8_t', '')
    
    IntOutput* get_identity_informationBootloaderMajoroutputwidget;
    
    // argument BootloaderMinor type ('uint8_t', '')
    
    IntOutput* get_identity_informationBootloaderMinoroutputwidget;
    
    // argument BootloaderBugfix type ('uint16_t', '')
    
    IntOutput* get_identity_informationBootloaderBugfixoutputwidget;
    
    // argument FirmwareMajor type ('uint8_t', '')
    
    IntOutput* get_identity_informationFirmwareMajoroutputwidget;
    
    // argument FirmwareMinor type ('uint8_t', '')
    
    IntOutput* get_identity_informationFirmwareMinoroutputwidget;
    
    // argument FirmwareBugfix type ('uint16_t', '')
    
    IntOutput* get_identity_informationFirmwareBugfixoutputwidget;
    
    // argument SerialNumber type ('uint32_t', '')
    
    IntOutput* get_identity_informationSerialNumberoutputwidget;
    
    // argument Reserved type ('uint8_t', '[8]')
    
    IntArrOutput* get_identity_informationReservedoutputwidget;
    

    // command get_calibration_settings
    iopanel* get_calibration_settingsiop;

    // req arguments
    // resp arguments
    // argument Reserved type ('uint8_t', '[4]')
    
    IntArrOutput* get_calibration_settingsReservedoutputwidget;
    

    // command set_calibration_settings
    iopanel* set_calibration_settingsiop;

    // req arguments
    // argument Reserved type ('uint8_t', '[4]')
        IntArrInput* set_calibration_settingsReservedinputwidget;
    
    // resp arguments

    // command get_conversion_raw
    iopanel* get_conversion_rawiop;

    // req arguments
    // resp arguments
    // argument data type ('uint16_t', '[10]')
    
    IntArrOutput* get_conversion_rawdataoutputwidget;
    

    // command get_conversion
    iopanel* get_conversioniop;

    // req arguments
    // resp arguments
    // argument data type ('uint16_t', '[10]')
    
    IntArrOutput* get_conversiondataoutputwidget;
    




public slots:
    void connectButton();
    void dconnectButton();

    void SearchSlot(QString str);

    void GetProfileSlot();
    void SetProfileSlot();

    /* slots for buttons
     * THIS CODE IS AUTOGENERATED
     */

    void get_identity_informationPressSlot(bool);

    void get_calibration_settingsPressSlot(bool);

    void set_calibration_settingsPressSlot(bool);

    void set_calibration_settingsCallGetterPressSlot(bool);
    void get_conversion_rawPressSlot(bool);

    void get_conversionPressSlot(bool);


private:
    Ui::MainWindow *ui;
};

#endif // MAINWINDOW_H
