# EPCboot GUI

Table of contents / Оглавление

[TOC]

------

### **Brief description**

EPCboot GUI is a cross–platform software with a graphical interface for updating firmware of devices manufactured by EPС MSU. 

EPCboot GUI is distributed both as Python source codes and as binary releases. Supports Windows and Linux operating systems.

------

### **User Manual** 

1. Go to the program directory.

2. Run the EPCboot GUI program: click on the executable file, or run the command from the command line (`epcboot_gui.exe ` on windows, `./epcboot_gui` on Linux).

3. Choose the COM port from the drop-down list. The COM port number can be viewed in the device manager on Windows or in the /dev directory on Linux (the device will most likely have a name in the ttyACMx format, where x is the device number).

4. Click "Browse" and specify path to the firmware file. The firmware file has the .cod extension, is included in the software package supplied with the device, can also be downloaded from the official website [eyepoint.physlab.ru](https://eyepoint.physlab.ru/en/).

5. Start the update with the "Update firmware" button and wait for it to finish. In the "Log" block, the inscription "INFO - Ok" will appear when the update is successful.

The functions from the "Developer mode" block are used in the production of equipment. If you are not engaged in the manufacture or repair of equipment, please do not use them. The functions contained in this block can lead to the loss of the firmware without the possibility of reinstalling it.

If you are a device developer, a guide to using the features of the "Developer mode" block is located below.

##### **Possible errors and warnings**

To track the progress of the EPCboot GUI program, please use the program "Log" block.

Possible causes of error messages and warnings (starting with the words "ERROR" or "WARNING"):

1. The device (COM port) is visible in the system, but not visible in EPCboot GUI. 

   The COM port may be held by another application. Close the program holding it and try the update again.

2. The device is not connected.

   Make sure that the device is turned on and properly connected to the computer. 

3. The device driver is not installed.

   Install the driver for your device. The driver is included in the software package supplied with the device, and it can also be downloaded from the official website [eyepoint.physlab.ru](https://eyepoint.physlab.ru/en/).

##### **Note for Linux users**

- If an error occurs with access permission, allow execution by running the command in the terminal:

  ```bash
  chmod ugo+x epcboot_gui
  ```

- To work correctly with COM ports, a user (with the name `username`) must be added to the "dialout" group. To add a user, run the command:

  ```bash
  sudo adduser username dialout
  ```

- On Linux machine we recommend to stop (or remove) the ModemManager. The ModemManager interferes with our bootloader.

  ```bash
  sudo systemctl stop ModemManager.service
  ```

------

###  **Device Developer’s Manual**

The initial installation of the firmware and its update is performed in accordance with the steps described in the "User Manual" section.

Important! Installing an incorrect key may prevent the firmware from being updated. In addition, using the functions of this unit will void the warranty of the device. If you are not sure of what to do, contact the device manufacturer.

##### **Uploading the encryption key file to the controller**

In the EPCboot GUI program, follow the steps:

1. Connect device and run the EPCboot GUI program as described above in the "User Manual" section.

2. Check the checkbox "Developer mode".

3. In the "Key" block, click the "Browse" button and specify path to the key file (.txt format).

4. Press the "Set key" button to load it into the controller.

##### **Serial number and version update**

Setting the serial number and version of the device without specifying the encryption key does not work. Make sure that the steps described in the previous section are completed.

Follow the steps:

1. Enter the serial number in the appropriate field.

2. Check the "Auto increment" checkbox if you want to download the firmware to multiple devices. This will automatically increase the serial number by one and simplify the work.

3. Enter the firmware version in the "HW Version" field and click "Set serial number and hardware version".

------

### **Software Developer's Manual**

The steps for building a binary release on Windows and Linux are described below. This section is intended for software developers.

##### **Building a Windows binary release**

In the epcboot_gui directory in command prompt/powershell build:

- with console for debugging:

  ```
  release.bat --console
  ```

- without console:

  ```
  release.bat --noconsole
  ```

##### **Building a Linux binary release**

In the epcboot_gui directory in terminal build:

```bash
source release.sh
```

##### **Run (python)**

In the epcboot_gui directory in cmd/powershell for Windows or terminal for Linux:

 ```bash
 python -m pip install -r requirements.txt
 cd epcboot_gui
 python main.py
 ```

NOTE

- On Linux machine we recommend to stop (or remove) the ModemManager. The ModemManager interferes with our bootloader.

  ```bash
  sudo systemctl stop ModemManager.service
  ```

------

### **Краткое** **описание**

EPCboot GUI – кроссплатформенное программное обеспечение с графическим интерфейсом для обновления прошивок устройств, выпускаемых ЦИФ МГУ. 

EPCboot GUI распространяется как в виде исходных кодов на языке Python, так и в виде бинарных релизов. Поддерживает операционные системы Windows и Linux.

------

### **Руководство пользователя**

##### **Обновление прошивки**

1. Перейдите в директорию программы.

2. Запустите программу epcboot_gui, кликнув по исполняемому файлу, либо выполнив команду через командную строку (`epcboot_gui.exe` на windows, `./epcboot_gui` на Linux).

3. Выберите из выпадающего списка COM-порт. Номер COM-порта можно посмотреть в диспетчере устройств ОС Windows или в директории /dev в ОС Linux (устройство, скорее всего, будет иметь имя в формате ttyACMx, где x – номер устройства).

4. Нажмите "Browse" и укажите путь к файлу прошивки. Файл прошивки имеет расширение .cod, входит в комплект ПО, поставляемый вместе с устройством, также может быть загружен с официального сайта [eyepoint.physlab.ru](https://eyepoint.physlab.ru/ru/).

5. Запустите обновление кнопкой "Update firmware" и дождитесь его окончания. При успешном обновлении в блоке "Log" появится надпись "INFO - Ok". 

Функции из блока "Developer mode" используются на производстве оборудования. Если вы не занимаетесь производством или ремонтом оборудования, пожалуйста, не используйте их. Функции, находящиеся в данном блоке, могут привести к потере прошивки без возможности её повторной установки. 

Если вы разработчик устройств, руководство по использованию возможностей блока "Developer mode" расположено ниже.

##### **Возможные ошибки и предупреждения**

Для отслеживания хода работы программы EPCboot GUI воспользуйтесь блоком "Log" программы. 

Возможные причины появления сообщений об ошибках и предупреждений (начинающихся со слов "ERROR" или "WARNING"): 

1. Устройство (COM порт) видится в системе, но не видится в EPCboot GUI. 

   COM-порт может удерижаться другим приложением. Закройте программу, удерживающую его, и повторите попытку обновления.

2. Устройство не подключено.

   Убедитесь, что устройство включено и правильно соединено с компьютером.

3. Не установлен драйвер устройства.

   Установите драйвер для вашего устройства. Драйвер входит в комплект ПО, поставляемый вместе с устройством, а также он может быть загружен с официального сайта [eyepoint.physlab.ru](https://eyepoint.physlab.ru/ru/).

##### **Примечание для пользователей** **Linux**

- Если возникает ошибка с разрешением доступа, разрешите выполнение, запустив команду в терминале:

  ```bash
  chmod ugo+x epcboot_gui
  ```

- Пользователь должен быть добавлен в группу "dialout", чтобы приложение корректно работало с COM-портами. Чтобы добавить пользователя (с именем `username`) в эту группу, выполните команду:

  ```bash
  sudo adduser username dialout
  ```

- Кроме того, мы рекомендуем остановить (или удалить) приложение ModemManager, так как оно вмешивается в работу нашего загрузчика.

  ```bash
  sudo systemctl stop ModemManager.service
  ```

------

### **Руководство для разработчиков устройств**

Первичная установка прошивки и её обновление производится в соответствии с шагами, описанными в разделе "Руководство пользователя". 

**Важно!** Установка неправильного ключа может привести к невозможности обновления прошивки. Кроме того, при использовании функций из данного блока устройство снимается с гарантии. Если вы не уверенны в своих действиях, обратитесь к производителям устройства.

##### **Загрузка файла ключа шифрования в контроллер**

В программе EPCboot GUI выполните шаги:

1. Подключите устройство и запустите программу EPCboot GUI, как было описано выше в разделе "Руководство пользователя".

2. Отметьте флажком чекбокс "Developer mode".

3. В блоке "Key" нажмите кнопку "Browse" и укажите путь к файлу ключа (формат .txt).

4. Нажмите кнопку "Set key" для его загрузки в контроллер.

##### **Обновление серийного номера и версии**

Если путь до файла с ключом шифрования не указан, укажите его (см. предыдущий раздел). Установка серийного номера и версии устройства без указания ключа не работает.

Выполните шаги:

1. Введите серийный номер в соответствующее поле.

2. Для упрощения работы при массовой прошивке устройств для автоматического увеличения серийного номера на единицу, отметьте флажком чекбокс "Auto increment".

3. Введите версию прошивки в поле "HW version" и нажмите кнопку "Set serial number and hardware version".

------

### **Руководство для разработчиков программного обеспечения**

Ниже описаны шаги для сборки бинарного релиза в Windows и Linux. Данный раздел предназначен для разработчиков программного обеспечения.

##### **Сборка бинарного релиза Windows**

В папке epcboot_gui в командной строке введите:

- для сборки с консольным выводом для отладки:

  ```bash
  release.bat --console
  ```

- для сборки графического приложения без отладочной консоли:

  ```bash
  release.bat --noconsole
  ```

##### **Сборка бинарного релиза Linux**

В каталоге epcboot_gui при сборке в терминале выполнить команду:

```bash
source release.sh
```

##### **Запуск (python)**

В папке epcboot_gui в cmd/powershell для Windows или в терминале для Linux:

```bash
python -m pip install -r requirements.txt
cd epcboot_gui
python main.py
```

##### **Примечание**

- Мы рекомендуем остановить (или удалить) приложение ModemManager, так как оно вмешивается в работу нашего загрузчика.

  ```bash
  sudo systemctl stop ModemManager.service
  ```

