


#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "intarroutput.h"
#include "intarrinput.h"

#include "intinput.h"
#include "intoutput.h"

#include "floatinput.h"
#include "floatoutput.h"

#include "floatarrinput.h"
#include "floatarroutput.h"

#include <QTime>
#include <QFileDialog>

// libs for type identification
#include <limits>
#include <stdint.h>

void MainWindow::AddIOPanel(iopanel* Panel)
{
    MainContainer->addTab(Panel, Panel->GetName());
}

MainWindow::MainWindow (QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    log = ui->LogWidget;
    QObject::connect(ui->ClearBtn, SIGNAL(clicked(bool)),log,SLOT(clear()));

    comedit = ui->comEdit;
    QObject::connect(ui->cntButton, SIGNAL(clicked(bool)),this,SLOT(connectButton()));
    QObject::connect(ui->dcntButton,SIGNAL(clicked(bool)),this,SLOT(dconnectButton()));

    // ToolTip
    #ifdef Q_OS_WIN32
    this->comedit->setToolTip("Example:\ncom:\\\\.\\COM12\nxi-net://192.168.0.1/00001234");
    #else
        #ifdef Q_OS_LINUX
    this->comedit->setToolTip("Example:\ncom:///dev/tty/ttyACM34\nxi-net://192.168.0.1/00001234");
        #else
    this->comedit->setToolTip("Example:\ncom:\\\\.\\COM12\ncom:///dev/tty/ttyACM34\nemu:///var/lib/ximc/virtual56.dat\nxi-net://192.168.0.1/00001234");
        #endif
    #endif

    // Main tab widget
    MainContainer = new Container();

    this->ui->verticalLayout->addWidget(MainContainer);

    // search panel
    QObject::connect(ui->SearchEdit, SIGNAL(textChanged(QString)), this, SLOT(SearchSlot(QString)));

    // profile get/set slots
    QObject::connect(ui->GetProfileBtn, SIGNAL(clicked(bool)), this, SLOT(GetProfileSlot()));
    QObject::connect(ui->SetProfileBtn, SIGNAL(clicked(bool)), this, SLOT(SetProfileSlot()));

    /* commands
     * THIS CODE IS AUTOGENERATED
     */

    

    

    // command get_identity_information
    get_identity_informationiop = new iopanel(NULL, "get_identity_information");
    this->AddIOPanel(get_identity_informationiop);
        get_identity_informationManufactureroutputwidget = new IntArrOutput(NULL,"Manufacturer", "uint8_t[16]");
    get_identity_informationiop->AddResponse(get_identity_informationManufactureroutputwidget);
    
        get_identity_informationProductNameoutputwidget = new IntArrOutput(NULL,"ProductName", "uint8_t[16]");
    get_identity_informationiop->AddResponse(get_identity_informationProductNameoutputwidget);
    
        get_identity_informationControllerNameoutputwidget = new IntArrOutput(NULL,"ControllerName", "uint8_t[16]");
    get_identity_informationiop->AddResponse(get_identity_informationControllerNameoutputwidget);
    
        get_identity_informationHardwareMajoroutputwidget = new IntOutput(NULL,"HardwareMajor", "uint8_t");
    get_identity_informationiop->AddResponse(get_identity_informationHardwareMajoroutputwidget);
    
        get_identity_informationHardwareMinoroutputwidget = new IntOutput(NULL,"HardwareMinor", "uint8_t");
    get_identity_informationiop->AddResponse(get_identity_informationHardwareMinoroutputwidget);
    
        get_identity_informationHardwareBugfixoutputwidget = new IntOutput(NULL,"HardwareBugfix", "uint16_t");
    get_identity_informationiop->AddResponse(get_identity_informationHardwareBugfixoutputwidget);
    
        get_identity_informationBootloaderMajoroutputwidget = new IntOutput(NULL,"BootloaderMajor", "uint8_t");
    get_identity_informationiop->AddResponse(get_identity_informationBootloaderMajoroutputwidget);
    
        get_identity_informationBootloaderMinoroutputwidget = new IntOutput(NULL,"BootloaderMinor", "uint8_t");
    get_identity_informationiop->AddResponse(get_identity_informationBootloaderMinoroutputwidget);
    
        get_identity_informationBootloaderBugfixoutputwidget = new IntOutput(NULL,"BootloaderBugfix", "uint16_t");
    get_identity_informationiop->AddResponse(get_identity_informationBootloaderBugfixoutputwidget);
    
        get_identity_informationFirmwareMajoroutputwidget = new IntOutput(NULL,"FirmwareMajor", "uint8_t");
    get_identity_informationiop->AddResponse(get_identity_informationFirmwareMajoroutputwidget);
    
        get_identity_informationFirmwareMinoroutputwidget = new IntOutput(NULL,"FirmwareMinor", "uint8_t");
    get_identity_informationiop->AddResponse(get_identity_informationFirmwareMinoroutputwidget);
    
        get_identity_informationFirmwareBugfixoutputwidget = new IntOutput(NULL,"FirmwareBugfix", "uint16_t");
    get_identity_informationiop->AddResponse(get_identity_informationFirmwareBugfixoutputwidget);
    
        get_identity_informationSerialNumberoutputwidget = new IntOutput(NULL,"SerialNumber", "uint32_t");
    get_identity_informationiop->AddResponse(get_identity_informationSerialNumberoutputwidget);
    
        get_identity_informationReservedoutputwidget = new IntArrOutput(NULL,"Reserved", "uint8_t[8]");
    get_identity_informationiop->AddResponse(get_identity_informationReservedoutputwidget);
    

    QObject::connect(get_identity_informationiop->PB, SIGNAL(clicked(bool)), this, SLOT(get_identity_informationPressSlot(bool)));


    // command get_calibration_settings
    get_calibration_settingsiop = new iopanel(NULL, "get_calibration_settings");
    this->AddIOPanel(get_calibration_settingsiop);
        get_calibration_settingsReservedoutputwidget = new IntArrOutput(NULL,"Reserved", "uint8_t[4]");
    get_calibration_settingsiop->AddResponse(get_calibration_settingsReservedoutputwidget);
    

    QObject::connect(get_calibration_settingsiop->PB, SIGNAL(clicked(bool)), this, SLOT(get_calibration_settingsPressSlot(bool)));


    // command set_calibration_settings
    set_calibration_settingsiop = new iopanel(NULL, "set_calibration_settings");
    this->AddIOPanel(set_calibration_settingsiop);
        set_calibration_settingsReservedinputwidget = new IntArrInput(NULL,"Reserved", "uint8_t[4]",std::numeric_limits<uint8_t>::min(),std::numeric_limits<uint8_t>::max(),4);
    set_calibration_settingsiop->AddRequest(set_calibration_settingsReservedinputwidget);
    


    QObject::connect(set_calibration_settingsiop->PB, SIGNAL(clicked(bool)), this, SLOT(set_calibration_settingsPressSlot(bool)));

        set_calibration_settingsiop->SetTypeSetter();
        QObject::connect(set_calibration_settingsiop->CallGetterBtn, SIGNAL(clicked(bool)), this, SLOT(set_calibration_settingsCallGetterPressSlot(bool)));

    // command get_conversion_raw
    get_conversion_rawiop = new iopanel(NULL, "get_conversion_raw");
    this->AddIOPanel(get_conversion_rawiop);
        get_conversion_rawdataoutputwidget = new IntArrOutput(NULL,"data", "uint16_t[10]");
    get_conversion_rawiop->AddResponse(get_conversion_rawdataoutputwidget);
    

    QObject::connect(get_conversion_rawiop->PB, SIGNAL(clicked(bool)), this, SLOT(get_conversion_rawPressSlot(bool)));


    // command get_conversion
    get_conversioniop = new iopanel(NULL, "get_conversion");
    this->AddIOPanel(get_conversioniop);
        get_conversiondataoutputwidget = new IntArrOutput(NULL,"data", "uint16_t[10]");
    get_conversioniop->AddResponse(get_conversiondataoutputwidget);
    

    QObject::connect(get_conversioniop->PB, SIGNAL(clicked(bool)), this, SLOT(get_conversionPressSlot(bool)));



    QObject::connect(ui->ClearBtn, SIGNAL(clicked(bool)),log,SLOT(clear()));

}

MainWindow::~MainWindow()
{
    usbadc10_close_device(&device);
    delete ui;
}


//--------------------------------------
void MainWindow::logAdd(QString str)
{
    log->addItem(QTime::currentTime().toString() + ": " +str);
    log->scrollToBottom();
}

//---------------------------------------
void MainWindow::logClear()
{
    log->clear();
}

//--------------------------connect\disconnect slots
void MainWindow::connectButton()
{
    usbadc10_close_device(&device);
    device = usbadc10_open_device(comedit->text().toStdString().c_str());

    if(device == device_undefined)
    {
        usbadc10_close_device(&device);
        logAdd(comedit->text()+ " device undefined");
    }
    else
    {
        logAdd(comedit->text()+ " connect");
    }

}

//------------------------------------------
void MainWindow::dconnectButton()
{
    usbadc10_close_device(&device);
    logAdd("Disconnect "+comedit->text());
}

/* slots for SEND buttons
 * THIS CODE IS AUTOGENERATED
 */

static const char * _err_list[] = { STR_result_ok_0,
									STR_device_undefined_1, 
                                    STR_result_not_implemented_2,
                                    STR_result_value_error_3,
                                    STR_result_nodevice_4 ,
                                    STR_result_timeout_5};



void MainWindow::get_identity_informationPressSlot(bool)
{
    int result = 0;
    usbadc10_get_identity_information_t output;
    result = usbadc10_get_identity_information(device,&output);
    if (result == result_ok || result == result_value_error)
    {
        
        get_identity_informationManufactureroutputwidget->setValue(output.Manufacturer, 16);
        get_identity_informationProductNameoutputwidget->setValue(output.ProductName, 16);
        get_identity_informationControllerNameoutputwidget->setValue(output.ControllerName, 16);
        get_identity_informationHardwareMajoroutputwidget->setValue(output.HardwareMajor);
        get_identity_informationHardwareMinoroutputwidget->setValue(output.HardwareMinor);
        get_identity_informationHardwareBugfixoutputwidget->setValue(output.HardwareBugfix);
        get_identity_informationBootloaderMajoroutputwidget->setValue(output.BootloaderMajor);
        get_identity_informationBootloaderMinoroutputwidget->setValue(output.BootloaderMinor);
        get_identity_informationBootloaderBugfixoutputwidget->setValue(output.BootloaderBugfix);
        get_identity_informationFirmwareMajoroutputwidget->setValue(output.FirmwareMajor);
        get_identity_informationFirmwareMinoroutputwidget->setValue(output.FirmwareMinor);
        get_identity_informationFirmwareBugfixoutputwidget->setValue(output.FirmwareBugfix);
        get_identity_informationSerialNumberoutputwidget->setValue(output.SerialNumber);
        get_identity_informationReservedoutputwidget->setValue(output.Reserved, 8);

    }

    if (result == device_undefined)
    {
        usbadc10_close_device(&device);
    }
    int abs_result = abs(result); 
    logAdd("usbadc10_get_identity_information returned "+(abs_result < (int)(sizeof(_err_list)/sizeof(_err_list[0])) ? 
		QString(_err_list[abs(result)]) : QString::number(result)));
}

void MainWindow::get_calibration_settingsPressSlot(bool)
{
    int result = 0;
    usbadc10_calibration_settings_t output;
    result = usbadc10_get_calibration_settings(device,&output);
    if (result == result_ok || result == result_value_error)
    {
        
        get_calibration_settingsReservedoutputwidget->setValue(output.Reserved, 4);

    }

    if (result == device_undefined)
    {
        usbadc10_close_device(&device);
    }
    int abs_result = abs(result); 
    logAdd("usbadc10_get_calibration_settings returned "+(abs_result < (int)(sizeof(_err_list)/sizeof(_err_list[0])) ? 
		QString(_err_list[abs(result)]) : QString::number(result)));
}

void MainWindow::set_calibration_settingsPressSlot(bool)
{
    int result = 0;
    usbadc10_calibration_settings_t input;

    set_calibration_settingsReservedinputwidget->getValue<uint8_t>(input.Reserved);

    result = usbadc10_set_calibration_settings(device,&input);

    if (result == device_undefined)
    {
        usbadc10_close_device(&device);
    }
    int abs_result = abs(result); 
    logAdd("usbadc10_set_calibration_settings returned "+(abs_result < (int)(sizeof(_err_list)/sizeof(_err_list[0])) ? 
		QString(_err_list[abs(result)]) : QString::number(result)));
}

void MainWindow::set_calibration_settingsCallGetterPressSlot(bool)
{
    get_calibration_settingsPressSlot(true);

    for (int i = 0; i < set_calibration_settingsiop->RequestsCount(); i++)
    {
        set_calibration_settingsiop->GetRequest(i)->SetText(get_calibration_settingsiop->GetResponse(i)->GetText());
    }
}
void MainWindow::get_conversion_rawPressSlot(bool)
{
    int result = 0;
    usbadc10_get_conversion_raw_t output;
    result = usbadc10_get_conversion_raw(device,&output);
    if (result == result_ok || result == result_value_error)
    {
        
        get_conversion_rawdataoutputwidget->setValue(output.data, 10);

    }

    if (result == device_undefined)
    {
        usbadc10_close_device(&device);
    }
    int abs_result = abs(result); 
    logAdd("usbadc10_get_conversion_raw returned "+(abs_result < (int)(sizeof(_err_list)/sizeof(_err_list[0])) ? 
		QString(_err_list[abs(result)]) : QString::number(result)));
}

void MainWindow::get_conversionPressSlot(bool)
{
    int result = 0;
    usbadc10_get_conversion_t output;
    result = usbadc10_get_conversion(device,&output);
    if (result == result_ok || result == result_value_error)
    {
        
        get_conversiondataoutputwidget->setValue(output.data, 10);

    }

    if (result == device_undefined)
    {
        usbadc10_close_device(&device);
    }
    int abs_result = abs(result); 
    logAdd("usbadc10_get_conversion returned "+(abs_result < (int)(sizeof(_err_list)/sizeof(_err_list[0])) ? 
		QString(_err_list[abs(result)]) : QString::number(result)));
}


void MainWindow::SearchSlot(QString str)
{
    MainContainer->Search(str);
}

void MainWindow::GetProfileSlot()
{
    QString FileName = QFileDialog::getSaveFileName(0, "Save profile...", "usbadc10.json", "JSON files (*.json);; All files (*)");

    if (FileName.isEmpty())
        return;

    QFile Profile(FileName);

    if (!Profile.open(QIODevice::WriteOnly))
    {
        this->logAdd("Error opening file");
        this->logAdd("Abort");
        return;
    }

    char *Buf = 0;

    int Result = usbadc10_get_profile(this->device, &Buf, malloc);

    if (Result == device_undefined)
    {
        usbadc10_close_device(&device);
    }

    logAdd("get_profile returned " + QString::number(Result));

    if ((Result != result_ok) && (Result != result_value_error))
    {
        logAdd("Abort");
        Profile.close();
        free(Buf);
        return;
    }

    Profile.write(Buf);

    if (Profile.error())
    {
        logAdd("File error:");
        logAdd(Profile.errorString());
        logAdd("Abort");
        free(Buf);
        return;
    }

    logAdd("Done");
    Profile.close();
    free(Buf);
}

void MainWindow::SetProfileSlot()
{
    QString FileName = QFileDialog::getOpenFileName(0, "Open profile...", ".json", "JSON files (*.json);; All files (*)");

    if (FileName.isEmpty())
        return;

    QFile Profile(FileName);

    if (!Profile.open(QIODevice::ReadOnly))
    {
        this->logAdd("Error opening file");
        this->logAdd("Abort");
        return;
    }
    static char *Buf;
    static unsigned int Size;

    Size = Profile.size();
    Buf = new char[Size]; // TODO: safe pointer?

    Profile.read(Buf, Size);
    Profile.close();

    if (Profile.error())
    {
        logAdd("File error:");
        logAdd(Profile.errorString());
        logAdd("Abort");
        delete[] Buf;
        return;
    }

    int Result = 0;
    // TODO: more safe try-catch block
    try
    {
        Result = usbadc10_set_profile(this->device, Buf);
        if (Result == device_undefined)
        {
            usbadc10_close_device(&device);
        }
    }
    catch(...)
    {
        logAdd("General error");
        logAdd("Abort");
        delete[] Buf;
        return;
    }
    logAdd("set_profile returned " + QString::number(Result));

    logAdd("Done");
    Profile.close();
}