using System;
using System.Runtime.InteropServices;
using System.Text;

namespace urpcadc {
	public enum Result {
	    ok = 0,
	    error = -1,
	    not_implemented = -2,
	    value_error = -3,
	    no_device = -4
	};
	public static class UrpcBuilderVersion {
	    public const int major = 0;
	    public const int minor = 10;
	    public const int bugfix = 4;
	    public const String suffix = "";
	    public const String version = "0.10.4";
	};
	[Flags] public enum Flags : uint {
	}
	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public struct get_identity_information_t {
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
		public byte[] Manufacturer;
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
		public byte[] ProductName;
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
		public byte[] ControllerName;
		public byte HardwareMajor;
		public byte HardwareMinor;
		public ushort HardwareBugfix;
		public byte BootloaderMajor;
		public byte BootloaderMinor;
		public ushort BootloaderBugfix;
		public byte FirmwareMajor;
		public byte FirmwareMinor;
		public ushort FirmwareBugfix;
		public uint SerialNumber;
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
		public byte[] Reserved;
	};
	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public struct debug_read_t {
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 128)]
		public byte[] DebugData;
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
		public byte[] Reserved;
	};
	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public struct debug_write_t {
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 128)]
		public byte[] DebugData;
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
		public byte[] Reserved;
	};
	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public struct get_conversion_raw_t {
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 10)]
		public ushort[] data;
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 12)]
		public byte[] Reserved;
	};
	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public struct get_conversion_t {
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 10)]
		public ushort[] data;
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 12)]
		public byte[] Reserved;
	};
	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public struct calibration_settings_t {
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
		public byte[] Reserved;
	};
	public partial class API {
		[DllImport("urpcadc", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
		public static extern int urpcadc_open_device([MarshalAs(UnmanagedType.LPStr)] String name);
		[DllImport("urpcadc", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
		public static extern int urpcadc_close_device([MarshalAs(UnmanagedType.LPStr)] String libver);
		[DllImport("urpcadc", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result urpcadc_close_device(ref int id);
		[DllImport("urpcadc", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result urpcadc_save_settings(int id);
		[DllImport("urpcadc", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result urpcadc_read_settings(int id);
		[DllImport("urpcadc", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result urpcadc_get_identity_information(int id, out get_identity_information_t output);
		[DllImport("urpcadc", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result urpcadc_reboot_to_bootloader(int id);
		[DllImport("urpcadc", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result urpcadc_debug_read(int id, out debug_read_t output);
		[DllImport("urpcadc", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result urpcadc_debug_write(int id, ref debug_write_t input);
		[DllImport("urpcadc", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result urpcadc_reset(int id);
		[DllImport("urpcadc", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result urpcadc_update_firmware(int id);
		[DllImport("urpcadc", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result urpcadc_get_calibration_settings(int id, out calibration_settings_t output);
		[DllImport("urpcadc", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result urpcadc_set_calibration_settings(int id, ref calibration_settings_t input);
		[DllImport("urpcadc", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result urpcadc_get_conversion_raw(int id, out get_conversion_raw_t output);
		[DllImport("urpcadc", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result urpcadc_get_conversion(int id, out get_conversion_t output);
	};
};