using System;
using System.Runtime.InteropServices;
using System.Text;

namespace usbadc10 {
	public enum Result {
	    ok = 0,
	    error = -1,
	    not_implemented = -2,
	    value_error = -3,
	    no_device = -4
	};
	public static class UrpcBuilderVersion {
	    public const int major = 0;
	    public const int minor = 10;
	    public const int bugfix = 23;
	    public const String suffix = "";
	    public const String version = "0.10.23";
	};
	[Flags] public enum Flags : uint {
	}
	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public struct get_identity_information_t {
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
		public byte[] Manufacturer;
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
		public byte[] ProductName;
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 16)]
		public byte[] ControllerName;
		public byte HardwareMajor;
		public byte HardwareMinor;
		public ushort HardwareBugfix;
		public byte BootloaderMajor;
		public byte BootloaderMinor;
		public ushort BootloaderBugfix;
		public byte FirmwareMajor;
		public byte FirmwareMinor;
		public ushort FirmwareBugfix;
		public uint SerialNumber;
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
		public byte[] Reserved;
	};
	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public struct get_conversion_raw_t {
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 10)]
		public ushort[] data;
	};
	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public struct get_conversion_t {
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 10)]
		public ushort[] data;
	};
	[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Ansi)]
	public struct calibration_settings_t {
		[MarshalAs(UnmanagedType.ByValArray, SizeConst = 4)]
		public byte[] Reserved;
	};
	public partial class API {
		[DllImport("usbadc10", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
		public static extern int usbadc10_open_device([MarshalAs(UnmanagedType.LPStr)] String name);
		[DllImport("usbadc10", CharSet = CharSet.Ansi, CallingConvention=CallingConvention.Cdecl)]
		public static extern int usbadc10_close_device([MarshalAs(UnmanagedType.LPStr)] String libver);
		[DllImport("usbadc10", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result usbadc10_close_device(ref int id);
		[DllImport("usbadc10", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result usbadc10_get_identity_information(int id, out get_identity_information_t output);
		[DllImport("usbadc10", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result usbadc10_get_calibration_settings(int id, out calibration_settings_t output);
		[DllImport("usbadc10", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result usbadc10_set_calibration_settings(int id, ref calibration_settings_t input);
		[DllImport("usbadc10", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result usbadc10_get_conversion_raw(int id, out get_conversion_raw_t output);
		[DllImport("usbadc10", CallingConvention=CallingConvention.Cdecl)]
		public static extern Result usbadc10_get_conversion(int id, out get_conversion_t output);
	};
};