#include "usbadc.h"
#include <algorithm>
#include <stdexcept>
#define PICOJSON_USE_INT64
#define PICOJSON_USE_UINT64
#include <picojson.h>
result_t usbadc_get_profile(device_t handle, char **buffer, void *(*allocate)(size_t))
{
    result_t result = result_ok;
    picojson::value::object profile_json;

    std::string out_str = picojson::value(profile_json).serialize(true);
    size_t size = out_str.size();
    (*buffer) = static_cast<char *>(allocate(size + 1));
    memcpy((*buffer), out_str.c_str(), size);
    (*buffer)[size] = '\0';
    return result;
}
result_t usbadc_set_profile(device_t handle, char *buffer)
{
    result_t result = result_ok;
    picojson::value profile_json;
    try
    {
        picojson::parse(profile_json, buffer);
    }
    catch(const std::exception &)
    {
        return result_error;
    }
    if(!profile_json.is<picojson::object>())
    {
        return result_error;
    }

    return result;
}
